/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;

public final class VWNodeType {
    private static final int MIN_NODE_TYPE = 1;
    public static final int NODE_TYPE_LAUNCH = 1;
    public static final int NODE_TYPE_START = 2;
    public static final int NODE_TYPE_OTHER = 3;
    private static final int MAX_NODE_TYPE = 3;
    private static String[] LocalizedStrings = new String[]{new VWString("VW.api.VWNodeTypeLaunch", "Launch").toString(), new VWString("VW.api.VWNodeTypeStart", "Start").toString(), new VWString("VW.api.VWNodeTypeOther", "Other").toString()};

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:38  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public static String getLocalizedString(int theNodeType) throws VWException {
        if (!VWNodeType.isValid(theNodeType)) {
            throw new VWException("vw.api.VWNodeTypeBadInteger", "Integer form of the node type is invalid: {0}", String.valueOf(theNodeType));
        }
        return LocalizedStrings[theNodeType - 1];
    }

    public static boolean isValid(int theNodeType) {
        return theNodeType >= 1 && theNodeType <= 3;
    }

    protected static String typeToString(int nodeType) throws VWException {
        switch (nodeType) {
            case 1: {
                return "launch";
            }
            case 2: {
                return "start";
            }
            case 3: {
                return "other";
            }
        }
        throw new VWException("vw.api.VWNodeTypeBadInteger", "Integer form of the node type is invalid: {0}", String.valueOf(nodeType));
    }

    protected static int stringToType(String nodeType) throws VWException {
        if (nodeType.equals("launch")) {
            return 2;
        }
        if (nodeType.equals("start")) {
            return 1;
        }
        if (nodeType.equals("other")) {
            return 3;
        }
        throw new VWException("vw.api.VWNodeTypeBadString", "String form of the node type is invalid: {0}", nodeType);
    }
}

